/** @file   HotSpot.h
 * @brief   Declaration of HotSpot class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/05/15 19:19:37 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_HOTSPOT_H
#define H_WWW_HOTSPOT_H

#include "GameObject.h"
#include "MUsableObject.h"

namespace WeWantWar {

/** @class  HotSpot
 * @brief   A baseclass for object that can be activated by the player or
 *          other objects.
 * @author  Tomi Lamminsaari
 *
 * This base class defines a protected pure virtual interface the actual
 * hot spot objects must implement.
 */
class HotSpot : public GameObject, public MUsableObject
{
public:

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   */
  HotSpot();

  /** Destructor
   */
  virtual ~HotSpot();

private:
  HotSpot( const HotSpot& aAnother );
  HotSpot& operator= ( const HotSpot& aAnother );
public:

  ///
  /// Inherited methods
  /// =================

  /** From GameObject.
   */
  virtual void update();
  
  /** From GameObject
   */
  virtual void redraw( RedrawQueue* aQueue );
   
  /** From GameObject
   */
  virtual bool hitByBullet( Bullet* aBullet );
  
  /** From GameObject
   */
  virtual void kill();
  
  /** From GameObject.
   */
  virtual void makeSound( GameObject::SoundID aSoundId ) const;
  
  /** From GameObject.
   */
  virtual ObjectID::Type objectType() const;
  
  /** From GameObject
   */
  virtual bool reloading() const;
  
  /** From MUsableObject
   */
  virtual int doActivate();
  
  /** From MUsableObject
   */
  virtual MUsableObject::State currentState() const;
  
protected:
  /** Called by the main update() method when this object is in starting
   * starting state.
   * @return  New state this object should advance to.
   */
  virtual MUsableObject::State updateStarting() = 0;
  
  /** Called by the main update() method when this object is in active
   * state.
   * @return  New state this object should advance to.
   */
  virtual MUsableObject::State updateActive() = 0;
  
  /** Called by the main update() method when this object is in stopping
   * state.
   * @return  New state this object should advance to.
   */
  virtual MUsableObject::State updateStopping() = 0;
  
  /** Called when this object is activated.
   */
  virtual void hotSpotActivated() = 0;
  
protected:
  MUsableObject::State iCurrentState;
};

};  // end of namespace

#endif
